/******************************************************************************
 CMonitorTask.cp

			Source File For CMonitorTask Class
	

	Copyright (C) 1985-1992  New York University
	Copyright (C) 1994 George Washington University
	 
	This file is part of the GWAdaEd system, an extension of the Ada/Ed-C
	system.  See the Ada/Ed README file for warranty (none) and distribution
	info and also the GNU General Public License for more details.


	by Manuel A. Perez

 ******************************************************************************/

#include "CMonitorTask.h"


/******************************************************************************
 Perform

		Do what's necessary to complete a chore. Subclasses must override
		this method. If the chore must be performed at some regular interval,
		the maxSleep parameter should be set to the maximum time, in ticks,
		between successive Perform() messages.
 ******************************************************************************/

void	CChore::Perform(
	long	*maxSleep)
{

	if (rProcessing && backgroundTask) {

		(*maxSleep) = 30;		/* 30 ticks = 1/2 second */
		if (!backgroundTask->StillRunning()) {
			short errs;

			errs = backgroundTask->ReadCompletionCode();
			if (errs == 0) {
				CBkgndTask *p;

				p = backgroundTask->GetNext();
				if (p) {
					// If we have another task pending, then delete
					// the one that just finished...
					
					backgroundTask->Cleanup();
					backgroundTask->Dispose();	// delete current

					// ... and start the next one
					backgroundTask = p;
					backgroundTask->StartRunning();
					rProcessing = backgroundTask->StillRunning();
				}


					// We don't have another process to run, so
					// update the user library (if neccessary) and
					// finish background processing
				else {

					// Update the library display if we were NOT
					// in the adaexec part of the compiler.					

					if (p->PartID() != kExec) {
						MenuHandle menu;

						assert(winLibrary);

						winLibrary->LibraryChanged();
						menu = gBartender->FindMacMenu(131);
						winLibrary->BuildBindMenu(menu);
			
						menu = gBartender->FindMacMenu(132);
						winLibrary->BuildExecuteMenu(menu);
					}

					backgroundTask->Cleanup();
					backgroundTask->Dispose();	// delete current
					backgroundTask = NULL;
					rProcessing = false;
				}

			}
			
				// Error Processing: call the background task object
				// to do whatever is appropriate.
			else {
				Str255 str;
				Str255 nameOnly;
				CBkgndTask *p;
				CSourceDocument *document;

				// This is temporary...
				if ((backgroundTask->PartID() == kFront) ||
					(backgroundTask->PartID() == kGen))
					GetIndString(str, 20030, 1);

				else if (backgroundTask->PartID() == kBind)
					GetIndString(str, 20030, 2);

				else
					CopyPString("\p", str);

				ParamText(str, "\p", "\p", "\p");
				StopAlert(20020, NULL);


				backgroundTask->ProcessError();
				backgroundTask->Cleanup();

				//backgroundTask->GetPgmName(nameOnly);
				//document = backgroundTask->GetDocument();

				// get rid of all pending tasks
				while (backgroundTask) {
					p = backgroundTask->GetNext();
					backgroundTask->Dispose();
					backgroundTask = p;
				}
				backgroundTask = NULL;


				rProcessing = false;
			}
		}
	}
}
